#!/usr/bin/python

import os, string, time, shutil

starttime = time.strftime('%X %x %Z')

xslfile = "normalize.xsl"
inputdir = "reflectxml"
outputdir = "normalized"

buildsetupstring="""
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="outputmode" select="'normalized'"/>
  <xsl:variable name="outputdir" select="'normalized'"/>
</xsl:stylesheet>
"""

setupfile = file("setupbuild.xsl","w")
setupfile.write(buildsetupstring)
setupfile.close()

if os.path.exists(outputdir):
    try:
        shutil.rmtree(outputdir)
    except:
        print "Warning (minor): unable to remove old files from", outputdir, "(a file may be in use by another process)"

if not os.path.exists(outputdir):
    os.makedirs(outputdir)
    

for infile in os.listdir(inputdir):
    if infile.endswith(".xml"):
        command = "saxon " + inputdir + '/' + infile + ' ' + xslfile + " > C:\\xmldoctemp.txt"
        os.system(command)

inputdir = "compileroutput"

for infile in os.listdir(inputdir):
    if infile.endswith(".xml"):
        command = "saxon " + inputdir + '/' + infile + ' ' + xslfile + " > C:\\xmldoctemp.txt"
        os.system(command)
    
xmlpathfile = open('xmlpathfile.xml', 'w')
xmlpathfile.write('<path>' + os.getcwd() + '</path>')
xmlpathfile.close()

xslfile = "csharpchop.xsl"

for infile in os.listdir(inputdir):
    if infile.endswith(".xml"):
        command = "saxon " + inputdir + '/' + infile + ' ' + xslfile + " > C:\\xmldoctemp.txt"
        os.system(command)

def templatecheck(arg, directory, filenames):
    for filename in filenames:
        if(os.path.isfile(os.path.join(directory, filename))):
            temp = directory.replace('content','templates')
            if(os.path.isfile(os.path.join(temp, filename))):
                os.remove(os.path.join(temp, filename))

os.path.walk('content', templatecheck, None)

